%%
% Theory spectrums for the two trees for a given transmission coefficient
% 'scat.t1'
%%
format long;

clear all;
close all;

%% Gamma of individual peaks (put by hand)

gamma_no_scat = zeros(2,12);
% Tree 1
gamma_no_scat(1,:) = [200 200 200 200 200 200 200 200 200 200 ...
        200 200]*1e3;
% Tree 2
gamma_no_scat(2,:) = [200 200 200 200 200 200 200 200 200 200 ...
        200 200]*1e3;

%% Some additional parameters related to experiment

% Constants
par.const.hbar = 6.62607004e-34/(2*pi);
par.const.c = 299792458;
par.const.T = 300;
par.const.kB = 1.38064852e-23;

% Parameters for mechanics
par.mech.omega = 2*pi*330e6;
par.mech.amech = 1.570496020158940e-05;
par.mech.length = 3*32;
par.mech.uc_meff = 2e-15;
par.mech.strip_meff = 2.0655e-14;
par.mech.meff = par.mech.strip_meff*par.mech.length;
par.mech.nb = par.const.kB*par.const.T/(par.const.hbar*par.mech.omega);

% Parameters for optics
par.opt.det = par.mech.omega;
par.opt.laser_power = 120e-6; % in Watts
par.opt.lambda = 1564.0562e-9;
par.opt.Qi = 163e3;
par.opt.Qe = 860e3;
par.opt.Qt = 137e3;

par.opt.omega = 2*pi*par.const.c/par.opt.lambda;
par.opt.a_in = sqrt(par.opt.laser_power/(par.const.hbar*par.opt.omega));
par.opt.Ki = par.opt.omega/par.opt.Qi;
par.opt.Ke = par.opt.omega/par.opt.Qe;
% par.opt.K = par.opt.Ki + par.opt.Ke;
par.opt.K = par.opt.omega/par.opt.Qt;
par.opt.nc = par.opt.Ke/2*par.opt.a_in^2/(par.opt.det^2 + ...
    par.opt.K^2/4);
par.opt.alpha = sqrt(par.opt.Ke/2)*par.opt.a_in/...
    (1i*par.opt.det - par.opt.K/2);

% OM and geometry parameters
% par.OM.unit_cell_g0 = 2*pi/sqrt(2)*sqrt(33^2 + 8^2)*1e3;
% par.OM.g0 = par.OM.unit_cell_g0/sqrt(par.mech.meff/par.mech.uc_meff);

%% Scattering matrix analysis

% Load band structure data values
load('./Data/experiment_compare_data_horizontal.mat');
load('./Data/experiment_compare_data_slant.mat');

% Get the range of energy values
energy_min = max(min(data_horz.energy), min(data_slant.energy)) ...
    + 50e3;
energy_max = min(max(data_horz.energy), max(data_slant.energy));

% Shift in spectrum
shift_freq = -7.430035853153955e6;

% Range of values of energy to check out for peak position
num_energy = 5e6;
energy = linspace(energy_min, energy_max, num_energy);

% Spectrum energy values
num_spe_energy = 1e3;
% ene_spe_min = 322e6;
% ene_spe_max = 331e6;
ene_spe_min = 321.5e6;
ene_spe_max = 331e6;
ene_spe = linspace(ene_spe_min - shift_freq, ene_spe_max - shift_freq, ...
    num_spe_energy);

% Find the k value for each energy via interpolation
kinterp.horz = interp1(data_horz.energy, data_horz.k, energy, 'spline');
kinterp.slant = interp1(data_slant.energy, data_slant.k, energy, 'spline');

g0interp.horz = interp1(data_horz.energy, data_horz.g0, energy, 'spline');
g0interp.slant = interp1(data_slant.energy, data_slant.g0, energy, 'spline');

horz_bot = [14 18];
y = zeros(size(horz_bot, 2), num_spe_energy);

% Reflection and transmission co-efficients (scat.t1 should not be exactly 1)
scat.t1 = sqrt(0.9999); scat.r1 = sqrt(1 - abs(scat.t1)^2);
scat.t2 = scat.t1; scat.r2 = sqrt(1 - abs(scat.t2)^2);

for j=1:size(horz_bot, 2)
% for j=1:1
    % Get g(beta) for each energy
    ct.amech = 1.570496020158940e-05;
    
    % Christmas tree parameters (length in number of snowflake unit cells)
    ct.tri_side = 25.575950949; % USE THIS ONE: Horizontal_v1 circumference length/3
    
    ct.real_tri_side = 32;
    ct.amech_corr = pi/data_horz.k(end);
    ct.Leff_corr = ct.tri_side*ct.amech/ct.amech_corr;

    ct.horz_bot = horz_bot(j)/32*ct.tri_side; % Horizontal bottom length
    ct.slant_bot = 6/32*ct.tri_side; % Slanted bottom length

    beta1 = kinterp.horz*ct.horz_bot*ct.amech;
    beta2 = kinterp.slant*ct.slant_bot*ct.amech;
    beta3 = kinterp.horz*(ct.tri_side - ct.horz_bot)/2*ct.amech;
    beta4 = kinterp.slant*(ct.tri_side - ct.slant_bot)*ct.amech;

    % Measurement node distance (calculated counter-clockwise from right corner)
    num_points = floor(1.5*ct.Leff_corr);
    dis_temp = -0.5*ct.horz_bot*ct.amech + ...
        linspace(0, num_points, num_points+1)*ct.amech_corr;
    dis_temp2 = 2*(1.5*ct.tri_side - ct.horz_bot/2)*ct.amech...
        - dis_temp(end:-1:2);

    % Total 75 sites
    % Tree 1: [5, 12, 32, 52, 59, 64, 75]
    % Tree 2: [4, 10, 30, 50, 56, 60, 75]
    dis_array = [mod(dis_temp,3*ct.tri_side*ct.amech) ...
        mod(dis_temp2,3*ct.tri_side*ct.amech)];
    dis_array = sort(dis_array);
    
    if j==1
        dis = dis_array(71);
    else
        dis = dis_array(71);
    end

    % Quadratic equation of the form: x^2+ax+1=0
    a = 1/(scat.t1^6.*scat.t2.*conj(scat.t1)^6.*conj(scat.t2)).*exp(-i.*(beta1+2.*(beta2+beta3+beta4))).*...
          (-exp(2i.*(beta1+2.*(beta2+beta3+beta4))).*scat.t1^6.*scat.t2+exp(4i.*(beta2+beta4)).*...
         scat.t1^6.*scat.t2.*conj(scat.r1)^6+2.*exp(2i.*(beta1+beta2+2.*(beta3+beta4))).*...
         scat.r1^2.*scat.t1^4.*scat.t2.*conj(scat.t1)^2+exp(4i.*(beta3+beta4)).*scat.r1^2.*scat.t1^2.*scat.t2.*...
         conj(scat.t1)^4-exp(2i.*(beta1+2.*(beta3+beta4))).*scat.r1^4.*scat.t1^2.*scat.t2.*conj(scat.t1)^4-...
          exp(2i.*(beta3+beta4)).*scat.r1.*scat.t1.*scat.t2.*conj(scat.r2).*conj(scat.t1).*...
          (exp(2i.*(beta1+2.*beta2+beta3)).*scat.t1^4-exp(2i.*(beta1+beta2)).*...
          (-1+2.*exp(2i.*beta3).*scat.r1^2).*scat.t1^2.*conj(scat.t1)^2+(-1+exp(2i.*beta1).*scat.r1^2).*...
          (-1+exp(2i.*beta3).*scat.r1^2).*conj(scat.t1)^4)+exp(2i.*(beta1+2.*beta2+2.*beta3+beta4)).*...
         scat.r1.*scat.r2.*scat.t1^5.*conj(scat.t1).*conj(scat.t2)+exp(2i.*(beta1+2.*(beta2+beta3))).*scat.r1^2.*...
         scat.t1^4.*conj(scat.t1)^2.*conj(scat.t2)+exp(2i.*(beta1+beta2+beta3+beta4)).*scat.r1.*scat.r2.*...
         scat.t1^3.*conj(scat.t1)^3.*conj(scat.t2)-2.*exp(2i.*(beta1+beta2+2.*beta3+beta4)).*scat.r1^3.*...
          scat.r2.*scat.t1^3.*conj(scat.t1)^3.*conj(scat.t2)+2.*exp(2i.*(beta1+beta2+beta3)).*scat.r1^2.*scat.t1^2.*...
         conj(scat.t1)^4.*conj(scat.t2)-2.*exp(2i.*(beta1+beta2+2.*beta3)).*scat.r1^4.*scat.t1^2.*...
         conj(scat.t1)^4.*conj(scat.t2)+exp(2i.*(beta3+beta4)).*scat.r1.*scat.r2.*scat.t1.*conj(scat.t1)^5.*conj(scat.t2)-...
          exp(2i.*(beta1+beta3+beta4)).*scat.r1^3.*scat.r2.*scat.t1.*conj(scat.t1)^5.*conj(scat.t2)-...
          exp(2i.*(2.*beta3+beta4)).*scat.r1^3.*scat.r2.*scat.t1.*conj(scat.t1)^5.*conj(scat.t2)+...
          exp(2i.*(beta1+2.*beta3+beta4)).*scat.r1^5.*scat.r2.*scat.t1.*conj(scat.t1)^5.*conj(scat.t2)-...
         conj(scat.t1)^6.*conj(scat.t2)+exp(2i.*beta1).*scat.r1^2.*conj(scat.t1)^6.*conj(scat.t2)+...
          2.*exp(2i.*beta3).*scat.r1^2.*conj(scat.t1)^6.*conj(scat.t2)-exp(4i.*beta3).*scat.r1^4.*conj(scat.t1)^6.*...
         conj(scat.t2)-2.*exp(2i.*(beta1+beta3)).*scat.r1^4.*conj(scat.t1)^6.*conj(scat.t2)+...
          exp(2i.*(beta1+2.*beta3)).*scat.r1^6.*conj(scat.t1)^6.*conj(scat.t2)+...
          exp(2i.*(2.*beta2+beta4)).*scat.t1^5.*conj(scat.r1)^5.*conj(scat.t1).*(scat.t2.*conj(scat.r2)-...
          scat.r2.*conj(scat.t2))-exp(2i.*beta2).*scat.t1^4.*conj(scat.r1)^4.*...
          (exp(2i.*(beta2+2.*beta4)).*(exp(2i.*beta1)+2.*exp(2i.*beta3)).*scat.t1^2.*scat.t2+...
          exp(2i.*(beta2+beta3+beta4)).*scat.r1.*scat.t1.*scat.t2.*conj(scat.r2).*conj(scat.t1)-...
          exp(2i.*(beta2+beta3+beta4)).*scat.r1.*scat.r2.*scat.t1.*conj(scat.t1).*conj(scat.t2)+conj(scat.t1)^2.*...
          (2.*exp(4i.*beta4).*scat.t2+exp(2i.*beta2).*conj(scat.t2)))+exp(2i.*beta2).*...
         scat.t1^3.*conj(scat.r1)^3.*conj(scat.t1).*(-exp(2i.*beta4).*scat.t2.*conj(scat.r2).*(exp(2i.*beta2).*...
          (exp(2i.*beta1)+exp(2i.*beta3)).*scat.t1^2+(2-exp(2i.*beta3).*scat.r1^2).*conj(scat.t1)^2)+...
          exp(2i.*(beta2+beta4)).*(exp(2i.*beta1)+exp(2i.*beta3)).*scat.r2.*scat.t1^2.*conj(scat.t2)-...
          exp(2i.*beta4).*(-2+exp(2i.*beta3).*scat.r1^2).*scat.r2.*conj(scat.t1)^2.*conj(scat.t2)+...
          2.*scat.r1.*scat.t1.*conj(scat.t1).*(exp(4i.*beta4).*(exp(2i.*beta1)+exp(2i.*beta3)).*scat.t2+...
          exp(2i.*(beta2+beta3)).*conj(scat.t2)))-scat.t1.*conj(scat.r1).*conj(scat.t1).*...
          (exp(2i.*beta4).*scat.t2.*conj(scat.r2).*(-exp(2i.*(beta1+2.*beta2+beta3)).*scat.t1^4+...
          exp(2i.*(beta2+beta3)).*(-1+2.*exp(2i.*beta1).*scat.r1^2+2.*exp(2i.*beta3).*scat.r1^2).*...
          scat.t1^2.*conj(scat.t1)^2-(-1+exp(2i.*beta1).*scat.r1^2).*(-1+exp(2i.*beta3).*scat.r1^2).*conj(scat.t1)^4)+...
          exp(2i.*(beta1+2.*beta2+beta3+beta4)).*scat.r2.*scat.t1^4.*conj(scat.t2)-exp(2i.*(beta2+beta3+beta4)).*...
          (-1+2.*exp(2i.*beta1).*scat.r1^2+2.*exp(2i.*beta3).*scat.r1^2).*scat.r2.*scat.t1^2.*conj(scat.t1)^2.*conj(scat.t2)+...
          exp(2i.*beta4).*(-1+exp(2i.*beta1).*scat.r1^2).*(-1+exp(2i.*beta3).*scat.r1^2).*scat.r2.*conj(scat.t1)^4.*...
          conj(scat.t2)+2.*exp(2i.*(beta2+beta3)).*scat.r1.*scat.t1^3.*conj(scat.t1).*(exp(4i.*beta4).*...
          (exp(2i.*beta1)+exp(2i.*beta3)).*scat.t2+exp(2i.*(beta1+beta2)).*conj(scat.t2))-...
          2.*scat.r1.*scat.t1.*conj(scat.t1)^3.*(exp(2i.*(beta3+2.*beta4)).*(-1+exp(2i.*beta1).*scat.r1^2).*scat.t2+...
          exp(2i.*beta2).*(exp(2i.*beta1)+exp(2i.*beta3)).*(-1+exp(2i.*beta3).*scat.r1^2).*...
          conj(scat.t2)))+scat.t1^2.*conj(scat.r1)^2.*(exp(2i.*(2.*beta2+beta3+2.*beta4)).*...
          (2.*exp(2i.*beta1)+exp(2i.*beta3)).*scat.t1^4.*scat.t2+exp(2i.*(beta2+beta4)).*scat.r1.*scat.t1.*...
          scat.t2.*conj(scat.r2).*conj(scat.t1).*(exp(2i.*(beta2+beta3)).*(exp(2i.*beta1)+...
          exp(2i.*beta3)).*scat.t1^2+(2.*exp(2i.*beta1)+2.*exp(2i.*beta3)-exp(2i.*(beta1+beta3)).*...
          scat.r1^2).*conj(scat.t1)^2)-exp(2i.*(2.*beta2+beta3+beta4)).*(exp(2i.*beta1)+...
          exp(2i.*beta3)).*scat.r1.*scat.r2.*scat.t1^3.*conj(scat.t1).*conj(scat.t2)+exp(2i.*(beta2+beta4)).*...
          scat.r1.*(-2.*exp(2i.*beta1)-2.*exp(2i.*beta3)+exp(2i.*(beta1+beta3)).*scat.r1^2).*...
          scat.r2.*scat.t1.*conj(scat.t1)^3.*conj(scat.t2)+conj(scat.t1)^4.*(-exp(4i.*beta4).*(-1+...
          exp(2i.*beta1).*scat.r1^2).*scat.t2-2.*exp(2i.*beta2).*(-1+exp(2i.*beta3).*scat.r1^2).*...
          conj(scat.t2))-exp(2i.*beta2).*scat.t1^2.*conj(scat.t1)^2.*(2.*exp(2i.*(beta3+2.*beta4)).*...
          (-1+exp(2i.*beta1).*scat.r1^2).*scat.t2-exp(2i.*beta2).*(exp(2i.*beta1)-...
          exp(4i.*beta3).*scat.r1^2).*conj(scat.t2))));

    % Peak positions
    [peak_pos(j,:), kpeak, vel, g0peak] = ...
        find_roots(energy, real(a)+2, kinterp, g0interp);
    
    % Mechanical damping factor Gamma
    Gamma = 200e3*ones(2, size(peak_pos,2));
    for k=1:size(gamma_no_scat,2)
        Gamma(j,2*k-1) = gamma_no_scat(j,k);
        Gamma(j,2*k) = gamma_no_scat(j,k);
    end
        
    % Spectrum at the measurement node
    g0_mech_cav = get_g0_mech_cav(kpeak, scat, dis, ct, vel, g0peak);
    g0_mech_cav = g0_mech_cav/sqrt(par.mech.length);
    
    % Including the optical backaction
%     y(j,:) = calc_SII(ene_spe, peak_pos(j,:), Gamma(j,:), ...
%         g0_mech_cav, par);

    % Ignoring the optical backaction
    y2(j,:) = calc_SII_analytical(ene_spe, peak_pos(j,:), ...
        Gamma(j,:), g0_mech_cav, par);
    y2(j,:) = y2(j,:)./(par.opt.Ke*par.opt.K/4*...
        abs(par.opt.alpha*chi_opt(ene_spe*2*pi,par) - ...
        conj(par.opt.alpha)*chi_opt(-ene_spe*2*pi,par)).^2);
end

%% Plotting spectrum

% Minimum and maximum value of y-axis
% basevalue = min(abs(y));
% maxvalue = 3e3;

figure(3)
hold on;
pbaspect([5.41 1 1])
set(gca,'FontSize',18)

xlim([ene_spe_min ene_spe_max])
% ylim([basevalue maxvalue])
xlabel('Frequency');
% ylabel('C S_{xx}/S_{xx}^{(SQL)}');
box on;

% Full numerics - including optical backaction
% area(ene_spe+shift_freq, y, basevalue, ...
%     'FaceColor', colour_area)
% plot(ene_spe+shift_freq, y(1,:), 'LineWidth', 2, 'Color', 'blue')
% plot(ene_spe+shift_freq, y(2,:), 'LineWidth', 2, 'Color', 'blue')

% Ignoring optical backaction
plot(ene_spe+shift_freq, y2(1,:), 'LineWidth', 2, 'Color', 'blue')
plot(ene_spe+shift_freq, y2(2,:), 'LineWidth', 2, 'Color', 'red')

%% Function definitions

    function y = chi_opt(w,par)
        y = 1./(par.opt.K/2 - 1i.*(w + par.opt.det));
    end